# Data types and keywords

## Data Types in C

Data type is basically a classification that defines what type of data a variable can hold and what kind of operations could be applied on it. 

> A variable in C is basically something that appears to hold some type of data. <br>
> An entity called 'format specifier' tells the C compiler about the data type of a variable or constant while initialising or calling it

### Data_types_table

<figure class=table><table><thead><tr><th>Data Type&nbsp;<br>&nbsp;<th>Memory (bytes)&nbsp;<br>&nbsp;<th>Range&nbsp;<br>&nbsp;<th>Format Specifier&nbsp;<br>&nbsp;<tbody><tr><td>short int&nbsp;<br>&nbsp;<td>2&nbsp;<br>&nbsp;<td>-32,768 to 32,767&nbsp;<br>&nbsp;<td>%hd&nbsp;<br>&nbsp;<tr><td>unsigned short int&nbsp;<br>&nbsp;<td>2&nbsp;<br>&nbsp;<td>0 to 65,535&nbsp;<br>&nbsp;<td>%hu&nbsp;<br>&nbsp;<tr><td>unsigned int&nbsp;<br>&nbsp;<td>4&nbsp;<br>&nbsp;<td>0 to 4,294,967,295&nbsp;<br>&nbsp;<td>%u&nbsp;<br>&nbsp;<tr><td>int&nbsp;<br>&nbsp;<td>4&nbsp;<br>&nbsp;<td>-2,147,483,648 to 2,147,483,647&nbsp;<br>&nbsp;<td>%d&nbsp;<br>&nbsp;<tr><td>long int&nbsp;<br>&nbsp;<td>4&nbsp;<br>&nbsp;<td>-2,147,483,648 to 2,147,483,647&nbsp;<br>&nbsp;<td>%ld&nbsp;<br>&nbsp;<tr><td>unsigned long int&nbsp;<br>&nbsp;<td>4&nbsp;<br>&nbsp;<td>0 to 4,294,967,295&nbsp;<br>&nbsp;<td>%lu&nbsp;<br>&nbsp;<tr><td>long long int&nbsp;<br>&nbsp;<td>8&nbsp;<br>&nbsp;<td>-(2^63) to (2^63)-1&nbsp;<br>&nbsp;<td>%lld&nbsp;<br>&nbsp;<tr><td>unsigned long long int&nbsp;<br>&nbsp;<td>8&nbsp;<br>&nbsp;<td>0 to 18,446,744,073,709,551,615&nbsp;<br>&nbsp;<td>%llu&nbsp;<br>&nbsp;<tr><td>signed char&nbsp;<br>&nbsp;<td>1&nbsp;<br>&nbsp;<td>-128 to 127&nbsp;<br>&nbsp;<td>%c&nbsp;<br>&nbsp;<tr><td>unsigned char&nbsp;<br>&nbsp;<td>1&nbsp;<br>&nbsp;<td>0 to 255&nbsp;<br>&nbsp;<td>%c&nbsp;<br>&nbsp;<tr><td>float&nbsp;<br>&nbsp;<td>4&nbsp;<br>&nbsp;<td>1.2E-38 to 3.4E+38&nbsp;<td>%f&nbsp;<br>&nbsp;<tr><td>double&nbsp;<br>&nbsp;<td>8&nbsp;<br>&nbsp;<td>	2.3E-308 to 1.7E+308&nbsp;<td>%lf&nbsp;<br>&nbsp;<tr><td>long double&nbsp;<br>&nbsp;<td>16&nbsp;<br>&nbsp;<td>3.4E-4932 to 1.1E+4932	&nbsp;<td>%Lf&nbsp;<br>&nbsp;</table></figure>

Table Credits : [GeeksforGeeks](https://www.geeksforgeeks.org/data-types-in-c/), [tutorialspoint](https://www.tutorialspoint.com/cprogramming/c_data_types.htm)
  
## Constants and Variables

Variables and constants in C are entities that 'appears to store' data.... eg `int a=10;` implies a variable that (appears to) store an integer of value 10..
  
What actually happens under the hood is that a variable doesn't literally 'store' data, rather variables are names of memory location that we use for storing data.  
So when we write `int a=10;`,we are basically taking a portion of our memory/RAM (here 4 bytes, since it is an integer) and calling it (that portion) `a`.

### Variables

- Variables are names of memory location that we use for storing data
- The value assigned to a variable can be changed throughout the program

Data Types of variables in C

- Primitive data types: Integer, float, character, etc. refer to <a href="#Data_types_table">Data types table</a> 
- Primitive data types are pre-defined or they already exist in the C language
> The data type `void` represents that there is an absence of type.
  
- Secondary data types: Array, structures, pointers, Enum, etc
- User-defined Data types derived from primary data types 
- eg arrays, structures, etc
  
#### Declaration and initialisation of variables
  
```c
#include<stdio.h>    
int main()
{    
    // Declaring and initialising a variable in one go 
    float PI=3.14;    
    printf("The value of PI is: %f",PI);
    // printing a new-line character
    printf("\n");
    // Declaring a variable first, initialising its value later
    int a;
    a=10;
    printf("a is %d\n", a);
    // Declaring two (or more) variables together
    int c, d;
    c=20;
    d=30;
    // if you want same value to multiple variables, you can do e.g., like this => c = d = 30 
    printf("c is %d and d is %d\n", c, d);
    return 0;  
}     
```

### Constants

- An entity that doesn't change
- Constants are similar to variables but the value of a constant can't be changed.

#### Declarationa and initialisation of constants
  
```c
#include<stdio.h>    
int main()
{    
    // Declaring a constant 
    const float PI=3.14;    
    printf("The value of PI is: %f",PI);    
    return 0;  
}     
```

There is another way to define a constant ie by using the ```#define``` preprocessor, but we'll get into that [later](https://github.com/realKarthikNair/Learning-C-Lang/blob/main/Learning_C/J.%20Preprocessor/Preprocessor%20DIrectives/notes/preprocessor_directives.md#2-macros)

  
### Keywords

Keywords are words that have pre-defined meaning to the compiler. e.g int means an integer

  <u>List of keywords in C Language</u> (source: [Microsoft Docs](https://docs.microsoft.com/en-us/cpp/c-language/c-keywords?view=msvc-170#:~:text=Keywords%20are%20words%20that%20have,phases%20in%20the%20Preprocessor%20Reference.))

<img src="https://user-images.githubusercontent.com/78267371/159726325-bc696706-3ef0-4926-8491-8cd7077f56f8.png" height="250px">

### Brief introduction to Functions

- Lines of code that does a particular task
- Functions are basically "called" to perform its predefined task
- eg the 'printf' function prints its parameters onto the output screen


